package org.bm.p2p.navigablep2p;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;

import org.apache.log4j.Logger;

/**
 * 
 * @author duanshuiliu
 * еĽڵ
 *
 */
public class Node {
	static final int BUCKETS = 16; // Ͱ(ֵ32ıҲ168)
	static final int K = 3; // ÿͰԪظ

	static Logger logger = Logger.getLogger(Node.class.getName());
	
	private int failNum = 0; // ھӽڵʱظڵĸ
	
	private BitSet nodePosition; //ڵλ

	private ArrayList<Node> outNeighbors[]; // ھӽڵб[ĳԪֵǾǸýڵͱڵľ]
	private ArrayList<Node> inNeighbors[]; // ھӽڵб[ĳԪֵǾǸýڵͱڵľ]
	private ArrayList<Node> incidentalNeighbors[]; // ˳ھӽڵб[ĳԪֵǾǸýڵͱڵľ]
	
	// ΪdistanceĽڵneighborھӽڵб
	public void setOutNeighbor(Node neighbor, int distance) {
		int i;
		// 벻ںϷΧڣ˳
		if (distance < 0 || distance >= BUCKETS) return;
		
		// distanceͰûѸýڵͰ
		if (outNeighbors[distance].size() < K) {
			for (i = 0; i < outNeighbors[distance].size(); i++) {
				//ڵѾڣ򷵻
				if (outNeighbors[distance].get(i)==neighbor){
					failNum ++;
					return;
				}
			}
			outNeighbors[distance].add(neighbor);
		}
		else {
			//ͰͰѡһ̭̭㷨ʹãο Kadmelia
			Random random = new Random();
			int chosedIdx = random.nextInt(K+1);
			if (chosedIdx < K)
				outNeighbors[distance].set(chosedIdx, neighbor);
			
		}
	}
	// þΪdistanceĳھ()
	public Node getOutNeighbor(int distance) {
		if (distance<0||distance>=BUCKETS) return null;
		if (outNeighbors[distance].size() > 0) {
			Random random = new Random();
			int chosenIdx = random.nextInt(outNeighbors[distance].size());
			return outNeighbors[distance].get(chosenIdx);
		}
		return null;
	}

	// þĿڵtargetNodeĳھ(ӦͰھ)
	public Node getOutNeighbor(Node targetNode) {
		Node neighbor = null;
		int distance = this.getDistanceFrom(targetNode);
		if (distance<0||distance>=BUCKETS) return null;

		int minDistance = distance;
		// ھӽڵбѡ
		if (outNeighbors[distance].size() > 0) {
			for (int i = 0; i < outNeighbors[distance].size(); i++) {
				if (outNeighbors[distance].get(i).getDistanceFrom(targetNode) < minDistance) {
					minDistance = outNeighbors[distance].get(i).getDistanceFrom(targetNode);
					neighbor = outNeighbors[distance].get(i);
				}
			}
		}
		return neighbor;
	}

	// þΪdistanceгھ
	public ArrayList<Node> getOutNeighbors(int distance) {
		return outNeighbors[distance];
	}
	
	// óھеС
	public int getOutMinDistance() {
		int i;
		for (i=0;i<BUCKETS;i++) {
			if (getOutNeighbor(i)!=null) break;
		}
		return i;
	}
	
	// ýڵĳھӸ
	public int getOutNeighborNum() {
		int neighborNum = 0;
		for (int i = 0; i < BUCKETS; i++) {
			neighborNum += outNeighbors[i].size();
		}
		return neighborNum;
	}
	
	// ɾһھ
	public int delOutNeighbor(Node neighbor) {
		int ret = -1;
		int distance = this.getDistanceFrom(neighbor);
		if (this.getOutNeighbors(distance).size()>0) {
			for (int i=0;i<this.getOutNeighbors(distance).size();i++) {
				if (this.getOutNeighbors(distance).get(i)==neighbor) {
					this.getOutNeighbors(distance).remove(i);
					ret = 0;
					break;
				}
			}
		}
		return ret;
	}
	
	// ΪdistanceĽڵneighborھӽڵб
	public void setInNeighbor(Node neighbor, int distance) {
		int i;
		// 벻ںϷΧڣ˳
		if (distance < 0 || distance >= BUCKETS) return;
		
		// distanceͰûѸýڵͰ
		if (inNeighbors[distance].size() < K) {
			for (i = 0; i < inNeighbors[distance].size(); i++) {
				//ڵѾڣ򷵻
				if (inNeighbors[distance].get(i)==neighbor){
					failNum ++;
					return;
				}
			}
			inNeighbors[distance].add(neighbor);
		}
		else {
			//ͰͰѡһ̭̭㷨ʹãο Kadmelia
			Random random = new Random();
			int chosedIdx = random.nextInt(K+1);
			if (chosedIdx < K)
				inNeighbors[distance].set(chosedIdx, neighbor);
			
		}
	}
	// þΪdistanceھ()
	public Node getInNeighbor(int distance) {
		if (distance<0||distance>=BUCKETS) return null;
		if (inNeighbors[distance].size() > 0) {
			Random random = new Random();
			int chosenIdx = random.nextInt(inNeighbors[distance].size());
			return inNeighbors[distance].get(chosenIdx);
		}
		return null;
	}

	// þĿڵtargetNodeھ(ӦͰھ)
	public Node getInNeighbor(Node targetNode) {
		Node neighbor = null;
		int distance = this.getDistanceFrom(targetNode);
		if (distance<0||distance>=BUCKETS) return null;

		int minDistance = distance;
		// ھӽڵбѡ
		if (inNeighbors[distance].size() > 0) {
			for (int i = 0; i < inNeighbors[distance].size(); i++) {
				if (inNeighbors[distance].get(i).getDistanceFrom(targetNode) < minDistance) {
					minDistance = inNeighbors[distance].get(i).getDistanceFrom(targetNode);
					neighbor = inNeighbors[distance].get(i);
				}
			}
		}
		return neighbor;
	}

	// þΪdistanceھ
	public ArrayList<Node> getInNeighbors(int distance) {
		return inNeighbors[distance];
	}
	
	// ھеС
	public int getInMinDistance() {
		int i;
		for (i=0;i<BUCKETS;i++) {
			if (getInNeighbor(i)!=null) break;
		}
		return i;
	}
	
	// ýڵھӸ
	public int getInNeighborNum() {
		int neighborNum = 0;
		for (int i = 0; i < BUCKETS; i++) {
			neighborNum += inNeighbors[i].size();
		}
		return neighborNum;
	}
	
	// ɾһھ
	public int delInNeighbor(Node neighbor) {
		int ret = -1;
		int distance = this.getDistanceFrom(neighbor);
		if (this.getInNeighbors(distance).size()>0) {
			for (int i=0;i<this.getInNeighbors(distance).size();i++) {
				if (this.getInNeighbors(distance).get(i)==neighbor) {
					this.getInNeighbors(distance).remove(i);
					ret = 0;
					break;
				}
			}
		}
		return ret;
	}
	
	// ΪdistanceĽڵneighbor˳ھӽڵб
	public void setIncidentalNeighbor(Node neighbor, int distance) {
		int i;
		// 벻ںϷΧڣ˳
		if (distance < 0 || distance >= BUCKETS) return;
		
		// distanceͰûѸýڵͰ
		if (incidentalNeighbors[distance].size() < K) {
			for (i = 0; i < incidentalNeighbors[distance].size(); i++) {
				//ڵѾڣ򷵻
				if (incidentalNeighbors[distance].get(i)==neighbor){
					failNum ++;
					return;
				}
			}
			incidentalNeighbors[distance].add(neighbor);
		}
		else {
			//ͰͰѡһ̭̭㷨ʹãο Kadmelia
			Random random = new Random();
			int chosedIdx = random.nextInt(K+1);
			if (chosedIdx < K)
				incidentalNeighbors[distance].set(chosedIdx, neighbor);
			
		}
	}
	// þΪdistance˳ھ()
	public Node getIncidentalNeighbor(int distance) {
		if (distance<0||distance>=BUCKETS) return null;
		if (incidentalNeighbors[distance].size() > 0) {
			Random random = new Random();
			int chosenIdx = random.nextInt(incidentalNeighbors[distance].size());
			return incidentalNeighbors[distance].get(chosenIdx);
		}
		return null;
	}

	// þĿڵtargetNode˳ھ(ӦͰھ)
	public Node getIncidentalNeighbor(Node targetNode) {
		Node neighbor = null;
		int distance = this.getDistanceFrom(targetNode);
		if (distance<0||distance>=BUCKETS) return null;

		int minDistance = distance;
		// ھӽڵбѡ
		if (incidentalNeighbors[distance].size() > 0) {
			for (int i = 0; i < incidentalNeighbors[distance].size(); i++) {
				if (incidentalNeighbors[distance].get(i).getDistanceFrom(targetNode) < minDistance) {
					minDistance = incidentalNeighbors[distance].get(i).getDistanceFrom(targetNode);
					neighbor = incidentalNeighbors[distance].get(i);
				}
			}
		}
		return neighbor;
	}

	// þΪdistance˳ھ
	public ArrayList<Node> getIncidentalNeighbors(int distance) {
		return incidentalNeighbors[distance];
	}
	

	// þĿڵtargetNodeھ(ӦͰھ)
	public Node getNeighbor(Node targetNode) {
		
		int inDistance,outDistance,incidentalDistance,minDistance;
		
		Node inNeighbor = getInNeighbor(targetNode);
		if (inNeighbor==null) inDistance=BUCKETS;
		else inDistance = inNeighbor.getDistanceFrom(targetNode);
		
		Node outNeighbor = getOutNeighbor(targetNode);
		if (outNeighbor==null) outDistance=BUCKETS;
		else outDistance = outNeighbor.getDistanceFrom(targetNode);
		
		Node incidentalNeighbor = getIncidentalNeighbor(targetNode);
		if (incidentalNeighbor==null) incidentalDistance=BUCKETS;
		else incidentalDistance = incidentalNeighbor.getDistanceFrom(targetNode);
		
		minDistance = inDistance;
		Node minNeighbor = inNeighbor;
		if (outDistance<minDistance) {
			minDistance = outDistance;
			minNeighbor = outNeighbor;
		}
		if (incidentalDistance<minDistance) {
			minDistance = incidentalDistance;
			minNeighbor = incidentalNeighbor;
		}

		return minNeighbor;
	}	
		
	//ʼڵ㣬λΪֵ
	@SuppressWarnings("unchecked")
	public Node() {
		super();
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandom();
		this.outNeighbors = new ArrayList[BUCKETS];
		this.inNeighbors = new ArrayList[BUCKETS];
		this.incidentalNeighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			outNeighbors[i] = new ArrayList<Node>();
			inNeighbors[i] = new ArrayList<Node>();
			incidentalNeighbors[i] = new ArrayList<Node>();
		}
	}

	//ʼڵ㣬λúͽڵnodeľdistanceѡȡ
	@SuppressWarnings("unchecked")
	public Node(Node node, int distance) {
		super();
		this.nodePosition = new BitSet(BUCKETS);
		this.setNodePositionRandomByDistance(node, distance);
		this.outNeighbors = new ArrayList[BUCKETS];
		this.inNeighbors = new ArrayList[BUCKETS];
		this.incidentalNeighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			outNeighbors[i] = new ArrayList<Node>();
			inNeighbors[i] = new ArrayList<Node>();
			incidentalNeighbors[i] = new ArrayList<Node>();
		}
	}
	// ʼڵ㣬λȷ
	@SuppressWarnings("unchecked")
	public Node(BitSet nodePosition) {
		super();
		this.nodePosition = nodePosition;
		this.outNeighbors = new ArrayList[BUCKETS];
		this.inNeighbors = new ArrayList[BUCKETS];
		this.incidentalNeighbors = new ArrayList[BUCKETS];
		for (int i = 0; i < BUCKETS; i++) {
			outNeighbors[i] = new ArrayList<Node>();
			inNeighbors[i] = new ArrayList<Node>();
			incidentalNeighbors[i] = new ArrayList<Node>();
		}
	}

	// ɽڵλ
	public void setNodePositionRandom() {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS<32)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		for (i =0 ; i < ((BUCKETS<32)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS<32)?BUCKETS:32); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}
	
	//ɺͽڵnodeľΪdistanceĽڵλ
	public void setNodePositionRandomByDistance(Node node, int distance) {
		Random random = new Random();
		int randomInt;
		boolean randomBool;
		int i,j;
		assert((BUCKETS%32==0)||(BUCKETS==16)||(BUCKETS==8)); //ѭԴΪǰ: BUCKETS32ıߵ16ߵ8
		assert(distance<BUCKETS&&distance>=0); // λ[0, BUCKETS-1]
		for (i =0 ; i < ((BUCKETS==16)||(BUCKETS==8)?1:BUCKETS/32); i++) { // BUCKETS/32
			randomInt = random.nextInt();
			//randomInt = (int) (random.nextGaussian()*Math.pow(2, 32));
			for(j =0 ; j < ((BUCKETS==8)?8:(BUCKETS==16?16:32)); j++) {
				if ((randomInt & 1) == 1) randomBool = true;
				else randomBool = false;
				nodePosition.set(i*32+j, randomBool);
				randomInt >>= 1; //һλ
			}
		}
		// Ӧλλ
		i = Node.BUCKETS-1;
		while (i>distance) {
			nodePosition.set(i, node.getNodePosition().get(i));
			i--;
		}
/*		for (i=0;i<BUCKETS;i++) {
			nodePosition.set(i, random.nextBoolean());
		}
*/	}

	public BitSet getNodePosition() {
		return nodePosition;
	}

	public void setNodePosition(BitSet nodePosition) {
		this.nodePosition = nodePosition;
	}
	
	// ͽڵnode֮ľ
	public int getDistanceFrom(Node node) {
		int ret = 0;
		// cloneڵ㣨ΪڼĹУxorڵľҪı䣩
		BitSet twinPosition = (BitSet) this.nodePosition.clone();
		twinPosition.xor(node.getNodePosition());
		ret = twinPosition.length() - 1;
		return ret;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((nodePosition == null) ? 0 : nodePosition.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Node other = (Node) obj;
		if (nodePosition == null) {
			if (other.nodePosition != null)
				return false;
		} else if (!nodePosition.equals(other.nodePosition))
			return false;
		return true;
	}
	
	// ڵھӽڵ
	public void outputNeighbors() {
		for (int i = 0; i < BUCKETS; i++) {
			if (outNeighbors[i].size()>0) {
				for (int j = 0; j < outNeighbors[i].size(); j++) {
					logger.info("neighbor "+i+"-"+j+" : "+outNeighbors[i].get(j).getNodePosition());
				}
			}
		}
	}

	// ýڵĳ/ھӸ
	public int getNeighborNum() {
		int neighborNum = 0;
		for (int i = 0; i < BUCKETS; i++) {
			neighborNum += outNeighbors[i].size();
			neighborNum += inNeighbors[i].size();
		}
		return neighborNum;
	}
	
	public double getFailNum() {
		return failNum;
	}
}
